

<?php $__env->startSection('title', 'Notifications'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-7xl mx-auto px-2 sm:px-4 lg:px-8">
    <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-4 sm:mb-6 gap-3">
        <h1 class="text-2xl sm:text-3xl font-bold text-gray-800">Notifications</h1>
        <div class="flex gap-2">
            <form method="POST" action="<?php echo e(route('pharmacist.notifications.mark-all-read')); ?>" class="inline">
                <?php echo csrf_field(); ?>
                <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-3 sm:px-4 py-2 rounded text-sm sm:text-base">
                    Mark All as Read
                </button>
            </form>
            <a href="<?php echo e(route('pharmacist.dashboard')); ?>" class="bg-gray-600 hover:bg-gray-700 text-white px-3 sm:px-4 py-2 rounded text-sm sm:text-base">
                <i class="fas fa-arrow-left"></i> <span class="hidden sm:inline">Back</span>
            </a>
        </div>
    </div>

    <?php if(session('success')): ?>
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
            <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>

    <div class="bg-white rounded-lg shadow">
        <?php $__empty_1 = true; $__currentLoopData = $notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="border-b border-gray-200 p-4 sm:p-6 <?php echo e($notification->read_at ? 'bg-white' : 'bg-blue-50'); ?>">
                <div class="flex justify-between items-start">
                    <div class="flex-1">
                        <div class="flex items-start gap-3">
                            <?php if(isset($notification->data['type']) && $notification->data['type'] === 'prescription_created'): ?>
                                <div class="p-2 bg-green-100 rounded-full">
                                    <i class="fas fa-prescription text-green-600"></i>
                                </div>
                            <?php else: ?>
                                <div class="p-2 bg-gray-100 rounded-full">
                                    <i class="fas fa-bell text-gray-600"></i>
                                </div>
                            <?php endif; ?>
                            
                            <div class="flex-1">
                                <p class="font-semibold text-gray-800 text-sm sm:text-base <?php echo e($notification->read_at ? '' : 'font-bold'); ?>">
                                    <?php echo e($notification->data['message'] ?? 'New notification'); ?>

                                </p>
                                
                                <?php if(isset($notification->data['type']) && $notification->data['type'] === 'prescription_created'): ?>
                                    <div class="mt-2 text-sm text-gray-600">
                                        <p><strong>Prescription #:</strong> <?php echo e($notification->data['prescription_number'] ?? 'N/A'); ?></p>
                                        <p><strong>Patient:</strong> <?php echo e($notification->data['patient_name'] ?? 'N/A'); ?></p>
                                        <p><strong>Doctor:</strong> <?php echo e($notification->data['doctor_name'] ?? 'N/A'); ?></p>
                                    </div>
                                    <div class="mt-3">
                                        <a href="<?php echo e(route('prescriptions.show', $notification->data['prescription_id'])); ?>" class="text-blue-600 hover:text-blue-900 text-sm">
                                            <i class="fas fa-eye"></i> View Prescription
                                        </a>
                                    </div>
                                <?php endif; ?>
                                
                                <p class="text-xs text-gray-500 mt-2"><?php echo e($notification->created_at->diffForHumans()); ?></p>
                            </div>
                        </div>
                    </div>
                    
                    <?php if(!$notification->read_at): ?>
                        <form method="POST" action="<?php echo e(route('pharmacist.notifications.mark-read', $notification->id)); ?>" class="ml-4">
                            <?php echo csrf_field(); ?>
                            <button type="submit" class="text-gray-400 hover:text-gray-600" title="Mark as read">
                                <i class="fas fa-check-circle"></i>
                            </button>
                        </form>
                    <?php endif; ?>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="p-8 text-center text-gray-500">
                <i class="fas fa-bell-slash text-4xl mb-4"></i>
                <p>No notifications found.</p>
            </div>
        <?php endif; ?>
    </div>

    <?php if($notifications->hasPages()): ?>
        <div class="mt-4">
            <?php echo e($notifications->links()); ?>

        </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\BrainTech\Documents\BEAUTEZ SYSTEM\resources\views/pharmacist/notifications.blade.php ENDPATH**/ ?>